<!--
;
; BaudTec Corporation
;
; --------------------------------------------------------------------------------
; Rev   Name    Date    Description
; --------------------------------------------------------------------------------
; R00   BAU-MCL 140710  Initial version.
; R01   BAU-RTK 140710  [Feature Enhancement]
;                       Realtek provides patch 140709_ipv6filter_block_icmp.rar . 
;                       It is from Hill's e-mail 2014-07-10 PM 03:21. 
;
;                       140709	Block icmpv6 from WAN to LAN for NetCologne default incoming rule. 
; 
-->

<html>
<! Copyright (c) Realtek Semiconductor Corp., 2003. All Rights Reserved. ->
<head>
<meta http-equiv="Content-Type" content="text/html" charset="utf-8">
<link rel="stylesheet" href="style/normal_ws.css" type="text/css">
<title>IPv6 IP/Port Filtering</title>
<script type="text/javascript" src="share.js">
</script>
<script>
function skip () { this.blur(); }

function protocolSelection()
{
	if ( document.formFilterAdd.protocol.selectedIndex == 2 )
	{
		document.formFilterAdd.sportStart.disabled = true;
		document.formFilterAdd.sportEnd.disabled = true;
		document.formFilterAdd.dportStart.disabled = true;
		document.formFilterAdd.dportEnd.disabled = true;
	}
	else 
	{
		document.formFilterAdd.sportStart.disabled = false;
		document.formFilterAdd.sportEnd.disabled = false;
		document.formFilterAdd.dportStart.disabled = false;
		document.formFilterAdd.dportEnd.disabled = false;
	}
}

function addClick()
{
	var ifid_regex = /[0-9A-F]{1,4}:[0-9A-F]{1,4}:[0-9A-F]{1,4}:[0-9A-F]{1,4}/i;  // interface Id is in this format: abcd:1:123:1234 or abcd:1111:2222:3333
	if (document.formFilterAdd.sIfId6Start.value == ""
			&& document.formFilterAdd.dIfId6Start.value == ""
			&& document.formFilterAdd.sfromPort.value == "" && document.formFilterAdd.dfromPort.value == "") {
		alert("Input Filter Rule is not valid!");
		document.formFilterAdd.sIfId6Start.focus();
		return false;
	}

	with ( document.forms[1] )	{
		if(sIfId6Start.value != ""){
			if (!sIfId6Start.value.match(ifid_regex) ){
				alert("Invalid Source IPv6 Interface ID Start address!");
				document.formFilterAdd.sIfId6Start.focus();
				return false;
			}
		}
		if(sIfId6End.value != ""){
			if(sIfId6Start.value == ""){
				alert("Invalid Source IPv6 Start address!");
				document.formFilterAdd.sIfId6Start.focus();
				return false;

			}
			else if (!sIfId6End.value.match(ifid_regex) ){
				alert("Invalid Source IPv6 End address!");
				document.formFilterAdd.sIfId6End.focus();
				return false;
			}
		}

		if(dIfId6Start.value != ""){
			if (!dIfId6Start.value.match(ifid_regex) ){
				alert("Invalid Destination IPv6 Start address!");
				document.formFilterAdd.dIfId6Start.focus();
				return false;
			}
		}

		if(dIfId6End.value != ""){
			if(dIfId6Start.value == ""){
				alert("Invalid  Destination IPv6 Start address!");
				document.formFilterAdd.dIfId6Start.focus();
				return false;

			}
			if (!dIfId6End.value.match(ifid_regex) ){
				alert("Invalid Destination IPv6 End address!");	
				document.formFilterAdd.dIfId6End.focus();
				return false;
			}
		}

		if ( document.formFilterAdd.sfromPort.value!="" ) {
			if ( validateKey( document.formFilterAdd.sfromPort.value ) == 0 ) {
				alert("Invalid source port!");
				document.formFilterAdd.sfromPort.focus();
				return false;
			}

			d1 = getDigit(document.formFilterAdd.sfromPort.value, 1);
			if (d1 > 65535 || d1 < 1) {
				alert("Invalid source port number!");
				document.formFilterAdd.sfromPort.focus();
				return false;
			}

			if ( document.formFilterAdd.stoPort.value!="" ) {
				if ( validateKey( document.formFilterAdd.stoPort.value ) == 0 ) {
					alert("Invalid source port!");
					document.formFilterAdd.stoPort.focus();
					return false;
				}

				d1 = getDigit(document.formFilterAdd.stoPort.value, 1);
				if (d1 > 65535 || d1 < 1) {
					alert("Invalid source port number!");
					document.formFilterAdd.stoPort.focus();
					return false;
				}
			}
		}

		if ( document.formFilterAdd.dfromPort.value!="" ) {
			if ( validateKey( document.formFilterAdd.dfromPort.value ) == 0 ) {
				alert("Invalid destination port!");
				document.formFilterAdd.dfromPort.focus();
				return false;
			}

			d1 = getDigit(document.formFilterAdd.dfromPort.value, 1);
			if (d1 > 65535 || d1 < 1) {
				alert("Invalid destination port number!");
				document.formFilterAdd.dfromPort.focus();
				return false;
			}

			if ( document.formFilterAdd.dtoPort.value!="" ) {
				if ( validateKey( document.formFilterAdd.dtoPort.value ) == 0 ) {
					alert("Invalid destination port!");
					document.formFilterAdd.dtoPort.focus();
					return false;
				}

				d1 = getDigit(document.formFilterAdd.dtoPort.value, 1);
				if (d1 > 65535 || d1 < 1) {
					alert("Invalid destination port number!");
					document.formFilterAdd.dtoPort.focus();
					return false;
				}
			}
		}
	}
	return true;
}

function disableDelButton()
{
  if (verifyBrowser() != "ns") {
	disableButton(document.formFilterDel.deleteSelFilterIpPort);
	disableButton(document.formFilterDel.deleteAllFilterIpPort);
  }
}

</script>
</head>

<body>
<blockquote>
<h2>IPv6 IP/Port Filtering</h2>

<table border=0 width="600" cellspacing=0 cellpadding=0>
<tr><td><font size=2>
 Entries in this table are used to restrict certain types of data packets through the Gateway. Use of such filters can be helpful in securing or restricting your local network.
</font></td></tr>

<tr><td><hr size=1 noshade align=top></td></tr>

<!--<form action=/boaform/formFilterV6 method=POST name="formFilterDefault">-->
<form action="fw-ipportfilter-v6_IfId.asp" method="post" name="formFilterDefault">


<tr><td><font size=2><b>Outgoing Default Action</b>&nbsp;&nbsp;
   	<input type="radio" name="outAct" value=0 >Deny&nbsp;&nbsp;
   	<input type="radio" name="outAct" value=1 checked>Allow&nbsp;&nbsp;
</font></td><tr>
<tr><td><font size=2><b>Incoming Default Action</b>&nbsp;&nbsp;
   	<input type="radio" name="inAct" value=0 >Deny&nbsp;&nbsp;
   	<input type="radio" name="inAct" value=1 checked>Allow&nbsp;&nbsp;
	<input type="submit" value="Apply Changes" name="setDefaultAction">&nbsp;&nbsp;
	<input type="hidden" value="/fw-ipportfilter-v6_IfId.asp" name="submit-url">
</font></td></tr>
</form>
</table>
<table border=0 width="600" cellspacing=0 cellpadding=0>
<tr><td><hr size=1 noshade align=top></td></tr>
<!--<form action=/boaform/formFilterV6 method=POST name="formFilterAdd">-->
<form action="fw-ipportfilter-v6_IfId.asp" name="formFilterAdd">

<tr>
	<td width="600"><font size=2>
	<b>Direction: </b>
		<select name=dir>
			<option select value=0>Outgoing</option>
			<option value=1>Incoming</option>
		</select>&nbsp;&nbsp;
	<b>Protocol: </b>
		<select name="protocol" onChange="protocolSelection()">
			<option select value=1>TCP</option>
			<option value=2>UDP</option>
			<option value=3>ICMPV6</option>
		</select>&nbsp;&nbsp;
	<b>Rule Action</b>
   		<input type="radio" name="filterMode" value="Deny" checked>&nbsp;Deny
   		<input type="radio" name="filterMode" value="Allow">&nbsp;&nbsp;Allow
	</font></td>
</tr>

<table cellSpacing="1" width="600" cellPadding="0" border="0">
   <tr>
	  <td width="35%"><font size=2><b>Source Interface ID:</b></td>
	  <!-- R01 <td><input type="text" size="16" name="sIfId6Start" style="width:150px"> - <input type="text" size="16" name="sIfId6End" style="width:150px"></td>  <td>EX:1111:2222:3333:4444-ffff:ffff:ffff:ffff </td> -->
	  <!-- R01 - start -->
	  <td><input type="text" size="16" name="sIfId6Start" style="width:150px"> - <input type="text" size="16" name="sIfId6End" style="width:150px"></td></tr>
  <tr><td>&nbsp;&nbsp;</td>
      <td><font size=2>EX:1111:2222:3333:4444-ffff:ffff:ffff:ffff </td>
	  <!-- R01 - end -->
   </tr>
   <tr><!-- R01 add -->	
	  <td width="35%"><font size=2><b>Destination Interface ID:</b></td>
	  <!-- R01 <td><input type="text" size="16" name="dIfId6Start" style="width:150px"> - <input type="text" size="16" name="dIfId6End" style="width:150px"></td>  <td>EX:1111:2222:3333:4444-ffff:ffff:ffff:ffff</td> -->
	  <!-- R01 - start -->
	  <td><input type="text" size="16" name="dIfId6Start" style="width:150px"> - <input type="text" size="16" name="dIfId6End" style="width:150px"></td></tr>
  <tr><td>&nbsp;&nbsp;</td>
  <td><font size=2>EX:1111:2222:3333:4444-ffff:ffff:ffff:ffff</td>
	  <!-- R01 - end -->
   </tr>
</table>

<table cellSpacing="1" width="600" cellPadding="0" border="0">
   <tr>
	  <td width="35%"><font size=2><b>Source Port:</b></td>
	  <td><input type="text" size="6" name="sfromPort" style="width:150px"> - <input type="text" size="6" name="stoPort" style="width:150px"></td>
   </tr>
   <tr>
	  <td width="35%"><font size=2><b>Destination Port:</b></td>
	  <td><input type="text" size="6" name="dfromPort" style="width:150px"> - <input type="text" size="6" name="dtoPort" style="width:150px"></td>
   </tr>
</table>

<tr>
	<td colspan="2">
	<input type="submit" value="Add" name="addFilterIpPort" onClick="return addClick()">
	<input type="hidden" value="/fw-ipportfilter-v6_IfId.asp" name="submit-url">
	</td>
</tr>
<tr><td colspan="2"><hr size=1 noshade align=top></td></tr>
</form>
</table>

<!--<form action=/boaform/formFilterV6 method=POST name="formFilterDel">-->
<form action="fw-ipportfilter-v6_IfId.asp" method="post" name="formFilterDel">
	<table border="0" width=600>
	<tr><font size=2><b>Current Filter Table:</b></font></tr>
	<tr><td align=center width="10%" bgcolor="#D0D0D0"><font size="2"><b>Select</b></font></td>
<td align=center width="15%" bgcolor="#D0D0D0"><font size="2"><b>Direction</b></font></td>
<td align=center width="15%" bgcolor="#D0D0D0"><font size="2"><b>Protocol</b></font></td>
<td align=center width="20%" bgcolor="#D0D0D0"><font size="2"><b>Source Interface ID</b></font></td>
<td align=center width="15%" bgcolor="#D0D0D0"><font size="2"><b>Source Port</b></font></td>
<td align=center width="20%" bgcolor="#D0D0D0"><font size="2"><b>Destination Interface ID</b></font></td>
<td align=center width="15%" bgcolor="#D0D0D0"><font size="2"><b>Destination Port</b></font></td>
<td align=center width="15%" bgcolor="#D0D0D0"><font size="2"><b>Rule Action</b></font></td></tr>

	</table>
	<br>
	<input type="submit" value="Delete Selected" name="deleteSelFilterIpPort" onClick="return deleteClick()">&nbsp;&nbsp;
	<input type="submit" value="Delete All" name="deleteAllFilterIpPort" onClick="return deleteAllClick()">&nbsp;&nbsp;&nbsp;
	<input type="hidden" value="/fw-ipportfilter-v6_IfId.asp" name="submit-url">
	<script>
		disableDelButton();
	</script>
</form>

</blockquote>
</body>
</html>
